private var pieceCenters : Vector3[];
private var pieceCountries : ArrayList[];
private var mymesh : Mesh;
private var myverts : Vector3[];
internal var countryPieces : ArrayList[];
internal var countryPieceCount : int[];

var politicalMap : Texture2D;
var indicator : GameObject;
var audioEnds : AudioClip[];
var audioEndsMiss : AudioClip[];
	

function Start() {
	CalculatePieces();
	countryPieces = new ArrayList[Country.Last];
	countryPieceCount = new int[Country.Last];
	for (var i : int = 0; i < Country.Last; ++i) {
		var ll : ArrayList = new ArrayList();
		countryPieces[i] = ll;
		var country : Country = i;
		for (var j = 0; j < pieceCountries.Length; ++j) {
			var l : ArrayList = pieceCountries[j];
			if (l.Contains(country)) {
				if (!ll.Contains(j)) {
					ll.Add(j);
				}
			}
		}
		countryPieceCount[i] = ll.Count;
	}
}

private function EmitSideQuad(
	verts:Vector3[], normals:Vector3[], uv:Vector2[], tris:int[],
	p0:Vector3, p1:Vector3, n0:Vector3, n1:Vector3, uv0:Vector2, uv1:Vector2,
	vidx : int, tidx : int )
{
	var n = -Vector3.Cross(p1-p0, -n0).normalized;
	uv[vidx+0] = uv0;
	uv[vidx+1] = uv1;
	uv[vidx+2] = uv0;
	uv[vidx+3] = uv1;
	normals[vidx+0] = n;
	normals[vidx+1] = n;
	normals[vidx+2] = n;
	normals[vidx+3] = n;
	verts[vidx+0] = p0;
	verts[vidx+1] = p1;
	verts[vidx+2] = p0 - n0*0.05;
	verts[vidx+3] = p1 - n1*0.05;
	tris[tidx+0] = vidx+0;
	tris[tidx+1] = vidx+2;
	tris[tidx+2] = vidx+1;
	tris[tidx+3] = vidx+1;
	tris[tidx+4] = vidx+2;
	tris[tidx+5] = vidx+3;
}

private function CountryFromUV (uv:Vector2) : Country
{
	var x : int = uv.x * politicalMap.width;
	var y : int = uv.y * politicalMap.height;
	var col = politicalMap.GetPixel (x,y);
	var code : int = Mathf.Round(col.a * 255 / 8);
	return code;
}
private function Tesselate( mesh : Mesh )
{
	var origTris = mesh.triangles;
	var origVerts = mesh.vertices;
	var origNormals = mesh.normals;
	var origUV = mesh.uv;
	
	var nidx = origTris.Length;
	var nvtx = origVerts.Length;

	var newVerts = new Vector3[nidx*3];
	var newNormals = new Vector3[nidx*3];
	var newUV = new Vector2[nidx*3];
	var newTris = new int[nidx*3];
	
	for( var i = 0; i < nidx/3; ++i ) {
		var idx0 = origTris[i*3+0];
		var idx1 = origTris[i*3+1];
		var idx2 = origTris[i*3+2];
		var p0 = origVerts[idx0];
		var p1 = origVerts[idx1];
		var p2 = origVerts[idx2];
		var n0 = origNormals[idx0];
		var n1 = origNormals[idx1];
		var n2 = origNormals[idx2];
		var uv0 = origUV[idx0];
		var uv1 = origUV[idx1];
		var uv2 = origUV[idx2];
		
		var p3 = (p0+p1+p2) / 3.0;
		var n3 = ((n0+n1+n2) / 3.0).normalized;
		var uv3 = (uv0+uv1+uv2) / 3.0;
		
		newVerts[i*9+0] = p0;
		newVerts[i*9+1] = p1;
		newVerts[i*9+2] = p3;
		newVerts[i*9+3] = p1;
		newVerts[i*9+4] = p2;
		newVerts[i*9+5] = p3;
		newVerts[i*9+6] = p2;
		newVerts[i*9+7] = p0;
		newVerts[i*9+8] = p3;
		
		newNormals[i*9+0] = n0;
		newNormals[i*9+1] = n1;
		newNormals[i*9+2] = n3;
		newNormals[i*9+3] = n1;
		newNormals[i*9+4] = n2;
		newNormals[i*9+5] = n3;
		newNormals[i*9+6] = n2;
		newNormals[i*9+7] = n0;
		newNormals[i*9+8] = n3;
		
		newUV[i*9+0] = uv0;
		newUV[i*9+1] = uv1;
		newUV[i*9+2] = uv3;
		newUV[i*9+3] = uv1;
		newUV[i*9+4] = uv2;
		newUV[i*9+5] = uv3;
		newUV[i*9+6] = uv2;
		newUV[i*9+7] = uv0;
		newUV[i*9+8] = uv3;
		
		for (var j = 0; j < 9; ++j)
			newTris[i*9+j] = i*9+j;
	}
	
	mesh.vertices = newVerts;
	mesh.normals = newNormals;
	mesh.uv = newUV;
	mesh.triangles = newTris;
}
/*
private function Tesselate( mesh : Mesh )
{
	var origTris = mesh.triangles;
	var origVerts = mesh.vertices;
	var origNormals = mesh.normals;
	var origUV = mesh.uv;
	
	var nidx = origTris.Length;
	var nvtx = origVerts.Length;

	var newVerts = new Vector3[nidx*4];
	var newNormals = new Vector3[nidx*4];
	var newUV = new Vector2[nidx*4];
	var newTris = new int[nidx*4];
	
	for( var i = 0; i < nidx/3; ++i ) {
		var idx0 = origTris[i*3+0];
		var idx1 = origTris[i*3+1];
		var idx2 = origTris[i*3+2];
		var p0 = origVerts[idx0];
		var p1 = origVerts[idx1];
		var p2 = origVerts[idx2];
		var n0 = origNormals[idx0];
		var n1 = origNormals[idx1];
		var n2 = origNormals[idx2];
		var uv0 = origUV[idx0];
		var uv1 = origUV[idx1];
		var uv2 = origUV[idx2];
		
		var p3 = (p0+p1) / 2.0;
		var n3 = ((n0+n1) / 2.0).normalized;
		var uv3 = (uv0+uv1) / 2.0;
		var p4 = (p1+p2) / 2.0;
		var n4 = ((n1+n2) / 2.0).normalized;
		var uv4 = (uv1+uv2) / 2.0;
		var p5 = (p2+p0) / 2.0;
		var n5 = ((n2+n0) / 2.0).normalized;
		var uv5 = (uv2+uv0) / 2.0;
		
		newVerts[i*12+ 0] = p0;
		newVerts[i*12+ 1] = p3;
		newVerts[i*12+ 2] = p5;
		newVerts[i*12+ 3] = p3;
		newVerts[i*12+ 4] = p1;
		newVerts[i*12+ 5] = p4;
		newVerts[i*12+ 6] = p5;
		newVerts[i*12+ 7] = p3;
		newVerts[i*12+ 8] = p4;
		newVerts[i*12+ 9] = p5;
		newVerts[i*12+10] = p4;
		newVerts[i*12+11] = p2;
		
		newNormals[i*12+ 0] = n0;
		newNormals[i*12+ 1] = n3;
		newNormals[i*12+ 2] = n5;
		newNormals[i*12+ 3] = n3;
		newNormals[i*12+ 4] = n1;
		newNormals[i*12+ 5] = n4;
		newNormals[i*12+ 6] = n5;
		newNormals[i*12+ 7] = n3;
		newNormals[i*12+ 8] = n4;
		newNormals[i*12+ 9] = n5;
		newNormals[i*12+10] = n4;
		newNormals[i*12+11] = n2;
		
		newUV[i*12+ 0] = uv0;
		newUV[i*12+ 1] = uv3;
		newUV[i*12+ 2] = uv5;
		newUV[i*12+ 3] = uv3;
		newUV[i*12+ 4] = uv1;
		newUV[i*12+ 5] = uv4;
		newUV[i*12+ 6] = uv5;
		newUV[i*12+ 7] = uv3;
		newUV[i*12+ 8] = uv4;
		newUV[i*12+ 9] = uv5;
		newUV[i*12+10] = uv4;
		newUV[i*12+11] = uv2;
		
		for (var j = 0; j < 12; ++j)
			newTris[i*12+j] = i*12+j;
	}
	
	mesh.vertices = newVerts;
	mesh.normals = newNormals;
	mesh.uv = newUV;
	mesh.triangles = newTris;
}
*/

private function CalculatePieces()
{
	var mf : MeshFilter = GetComponent(MeshFilter);
	var mesh = mf.mesh;
	
	Tesselate (mesh);
	
	var origTris = mesh.triangles;
	var origVerts = mesh.vertices;
	var origNormals = mesh.normals;
	var origUV = mesh.uv;
	
	var nidx = origTris.Length;
	var noldtris = nidx/3;
	var newnverts = nidx + noldtris * 3*4;
	var newnidx = nidx + noldtris * 3*6;
	
	var newVerts = new Vector3[newnverts];
	var newNormals = new Vector3[newnverts];
	var newUV = new Vector2[newnverts];
	var newTris = new int[newnidx];
	var i = 0;
	
	pieceCenters = new Vector3[noldtris];
	pieceCountries = new ArrayList[noldtris];
	
	// construct pieces
	for (i = 0; i < noldtris; ++i) {
		var idx0 = i*3+0;
		var idx1 = i*3+1;
		var idx2 = i*3+2;
		var p0 = origVerts[origTris[idx0]];
		var p1 = origVerts[origTris[idx1]];
		var p2 = origVerts[origTris[idx2]];
		var n0 = origNormals[origTris[idx0]];
		var n1 = origNormals[origTris[idx1]];
		var n2 = origNormals[origTris[idx2]];
		var uv0 = origUV[origTris[idx0]];
		var uv1 = origUV[origTris[idx1]];
		var uv2 = origUV[origTris[idx2]];
		
		// original triangle
		newVerts[i*15+0] = p0;
		newVerts[i*15+1] = p1;
		newVerts[i*15+2] = p2;
		newNormals[i*15+0] = n0;
		newNormals[i*15+1] = n1;
		newNormals[i*15+2] = n2;
		newUV[i*15+0] = uv0;
		newUV[i*15+1] = uv1;
		newUV[i*15+2] = uv2;
		newTris[i*21+0] = i*15+0;
		newTris[i*21+1] = i*15+1;
		newTris[i*21+2] = i*15+2;
		// 3 quads at each side
		EmitSideQuad( newVerts, newNormals, newUV, newTris, p0, p1, n0, n1, uv0, uv1, i*15+ 3, i*21+ 3 );
		EmitSideQuad( newVerts, newNormals, newUV, newTris, p1, p2, n1, n2, uv1, uv2, i*15+ 7, i*21+ 9 );
		EmitSideQuad( newVerts, newNormals, newUV, newTris, p2, p0, n2, n0, uv2, uv0, i*15+11, i*21+15 );
		
		// center point of the piece
		pieceCenters[i] = (p0+p1+p2) / 3.0;
		
		// country from UV
		var l = new ArrayList();
		var c : Country;
		c = CountryFromUV (uv0); if (!l.Contains(c)) l.Add(c);
		c = CountryFromUV (uv1); if (!l.Contains(c)) l.Add(c);
		c = CountryFromUV (uv2); if (!l.Contains(c)) l.Add(c);
		c = CountryFromUV ((uv0+uv1)*0.5); if (!l.Contains(c)) l.Add(c);
		c = CountryFromUV ((uv1+uv2)*0.5); if (!l.Contains(c)) l.Add(c);
		c = CountryFromUV ((uv2+uv0)*0.5); if (!l.Contains(c)) l.Add(c);
		c = CountryFromUV ((uv0+uv1+uv2)/3.0); if (!l.Contains(c)) l.Add(c);
		pieceCountries[i] = l;
	}
	
	mesh.vertices = newVerts;
	mesh.normals = newNormals;
	mesh.uv = newUV;
	mesh.triangles = newTris;
	myverts = newVerts;
	
	mymesh = mesh;
}

private function ExplodePiece (idx:int) {
	for( var i = idx*15; i < (idx+1)*15; ++i )
		myverts[i] = Vector3.zero;
	mymesh.vertices = myverts;
}

private function Explode (pos:Vector3) {
	pos = transform.InverseTransformPoint(pos);
	var radius = 0.08;
	var radius2 = radius*radius;
	var n = pieceCenters.Length;
	var list = new ArrayList();
	for( var i = 0; i < n; ++i ) {
		if ((pieceCenters[i]-pos).sqrMagnitude < radius2) {
			ExplodePiece (i);
			for (var c:Country in pieceCountries[i]) {
				if (c != Country.None) {
					var cpieces : ArrayList = countryPieces[c];
					var oldSize = cpieces.Count;
					cpieces.Remove(i);
					if (cpieces.Count != oldSize) {
						if (!list.Contains(c)) {
							list.Add(c);
						}
					}
				}
			}
		}
	}
	
	for (var c : Country in list) {
		var idx : int = c;
		var go = GameObject.Instantiate (indicator, transform.position, transform.rotation);
		go.renderer.material.SetFloat("_Active", idx*8.0/255.0);
		Destroy(go,1.0);
		
		// did we kill this country?
		var chit = CountryHit();
		chit.country = idx;
		chit.left = countryPieces[idx].Count;
		chit.total = countryPieceCount[idx];
		Camera.main.SendMessage ("HitCountry", chit);
	}
	
	// explosion sound
	var sounds : AudioClip[] = (list.Count > 0) ? audioEnds : audioEndsMiss;
	AudioSource.PlayClipAtPoint (
		sounds[Random.Range(0,sounds.Length)],
		pos, 1.0);
}

function YouAreHit (contact : ContactPoint) {
	Explode (contact.point);
}

/*
function Update()
{
	if(Input.GetButtonDown("Fire1")) {
		var hit : RaycastHit;
		var ray = Camera.main.ScreenPointToRay(Input.mousePosition);
		if(Physics.Raycast(ray, hit)) {
			Explode (hit.point);
		}
	}
}
*/


/*
var debugCountry = Country.Madagascar;

function OnDrawGizmos()
{
	if (countryPieces == null || pieceCenters==null)
		return;
		
	var idx : int = debugCountry;
	for (var p in countryPieces[idx]) {
		var center = pieceCenters[p];
		Gizmos.DrawCube(transform.TransformPoint(center), Vector3(0.1,0.1,0.1));
	}
}
*/
